<?php

// =====================================================================
// ---         توابع ارتباط با API پنل MahXray                       ---
// =====================================================================

function mahxrayApiRequest($endpoint, $server_id, $data = []) {
    $stmt = pdo()->prepare("SELECT url, username FROM servers WHERE id = ?");
    $stmt->execute([$server_id]);
    $server_info = $stmt->fetch();
    if (!$server_info) {
        return ['status' => 'FAILED', 'message' => 'MahXray server not configured in the bot.'];
    }

    $url = rtrim($server_info['url'], '/') . '/' . $endpoint;
    $data['api_key'] = $server_info['username'];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url, CURLOPT_RETURNTRANSFER => true, CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_TIMEOUT => 20,
        CURLOPT_SSL_VERIFYPEER => false, CURLOPT_SSL_VERIFYHOST => false,
    ]);
    $response_body = curl_exec($ch);
    curl_close($ch);
    return json_decode($response_body, true);
}


// =====================================================================
// ---         توابع مربوط به خرید و مدیریت سرویس کاربر              ---
// =====================================================================

function createMahxrayCodeByPlan($plan_id, $chat_id) {
   
    $stmt_server = pdo()->prepare("SELECT id FROM servers WHERE type = 'mahxray' LIMIT 1");
    $stmt_server->execute();
    $server_id = $stmt_server->fetchColumn();
    if (!$server_id) return false;
    
   
    $stmt_plan = pdo()->prepare("SELECT * FROM mahxray_plans WHERE id = ?");
    $stmt_plan->execute([$plan_id]);
    $plan = $stmt_plan->fetch();
    if (!$plan) return false;

   
    $params = [
        'month' => $plan['duration_months'], 
        'max_user' => $plan['max_users'],
        'count' => 1,
        'status' => 1
    ];
    

    $response = mahxrayApiRequest('add_code.php', $server_id, $params);

    if (isset($response['status']) && $response['status'] == 'OK') {
        $activation_code = $response['code'];
        
        $expire_timestamp = time() + ($plan['duration_months'] * 86400); 
        
        $stmt_save = pdo()->prepare(
            "INSERT INTO services (owner_chat_id, server_id, marzban_username, plan_id, sub_url, expire_timestamp, volume_gb) VALUES (?, ?, ?, 0, ?, ?, ?)"
        );
        $stmt_save->execute([$chat_id, $server_id, $activation_code, $activation_code, $expire_timestamp, $plan['max_users']]);
        
        return ['code' => $activation_code, 'plan' => $plan];
    }
    
    error_log("Failed to create MahXray code. PlanID: {$plan_id}. Response: " . json_encode($response));
    return false;
}

function getMahxrayUser($activation_code, $server_id) {
    $response = mahxrayApiRequest('get_detail_code.php', $server_id, ['code' => $activation_code]);
    if (isset($response['sessions'])) {
        $connected_devices = count($response['sessions']);
        
      
        $stmt_local = pdo()->prepare("SELECT * FROM services WHERE marzban_username = ? AND server_id = ?");
        $stmt_local->execute([$activation_code, $server_id]);
        $local_service = $stmt_local->fetch();
        if (!$local_service) return false;
        
        return [
            'status' => 'active', 
            'expire' => $local_service['expire_timestamp'] ?? 0,
            'used_traffic' => $connected_devices, 
            'data_limit' => $local_service['volume_gb'], 
            'links' => ["`{$activation_code}`"],
        ];
    }
    return false;
}

function deleteMahxrayUser($activation_code, $server_id) {
    $response = mahxrayApiRequest('delete_code.php', $server_id, ['code' => $activation_code]);
    return isset($response['status']) && $response['status'] == 'OK';
}


// =====================================================================
// ---             توابع مدیریتی برای ادمین ربات                     ---
// =====================================================================

function getMahxrayPlans() {
    return pdo()->query("SELECT * FROM mahxray_plans WHERE status = 'active' ORDER BY price ASC")->fetchAll(PDO::FETCH_ASSOC);
}

function getAllMahxrayPlansForAdmin() {
    return pdo()->query("SELECT * FROM mahxray_plans ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
}

function searchMahxrayCode($key, $server_id) {
    return mahxrayApiRequest('search_code.php', $server_id, ['key' => $key]);
}

function resetMahxrayCode($old_code, $server_id) {
    return mahxrayApiRequest('reset_code.php', $server_id, ['code' => $old_code]);
}

function getMahxrayCodeSessions($code, $server_id) {
    $response = mahxrayApiRequest('get_detail_code.php', $server_id, ['code' => $code]);
    return $response['sessions'] ?? [];
}

function deleteMahxraySession($session_id, $server_id) {
    $response = mahxrayApiRequest('delete_session.php', $server_id, ['id' => $session_id]);
    return isset($response['status']) && $response['status'] == 'OK';
}